<?php
/**
 * Theme functions and definitions
 *
 * @package HelloElementor
 */

// Custom Code
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart' );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 10 );

// Default image for Products 

 add_action( 'init', 'custom_fix_thumbnail' );
  function custom_fix_thumbnail() {
	add_filter('woocommerce_placeholder_img_src', 'custom_woocommerce_placeholder_img_src');
	 
	  function custom_woocommerce_placeholder_img_src( $src ) {
	  $upload_dirs = get_template_directory_uri();
	  $src = $upload_dirs . '/assets/images/productimage.png';
	   
	  return $src;
	  }
  } 
//Disallow visitor to access wp-json

$url = get_site_url();

add_filter( 'rest_api_init', 'rest_only_for_authorized_users', 99 );
function rest_only_for_authorized_users($wp_rest_server)
{
	if ( !is_user_logged_in() ) 
	{	
		wp_redirect(home_url());
		exit;
	}
    
}


function arphabet_widgets_init() {

    register_sidebar( array(
        'name' => 'Sidebar',
        'id' => 'home_right_1',
        'before_widget' => '<div>',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="rounded">',
        'after_title' => '</h2>',
    ) );
}
add_action( 'widgets_init', 'arphabet_widgets_init' );

add_action( 'init', 'create_product_taxonomies', 0 );

// create two taxonomies, genres and writers for the post type "book"
function create_product_taxonomies() {
	// Add new taxonomy, make it hierarchical (like categories)
	$labels = array(
		'name'              => _x( 'Industries', 'taxonomy general name', 'textdomain' ),
		'singular_name'     => _x( 'Industry', 'taxonomy singular name', 'textdomain' ),
		'search_items'      => __( 'Search Industry', 'textdomain' ),
		'all_items'         => __( 'All Industry', 'textdomain' ),
		'parent_item'       => __( 'Parent Industry', 'textdomain' ),
		'parent_item_colon' => __( 'Parent Industry:', 'textdomain' ),
		'edit_item'         => __( 'Edit Industry', 'textdomain' ),
		'update_item'       => __( 'Update Industry', 'textdomain' ),
		'add_new_item'      => __( 'Add New Industry', 'textdomain' ),
		'new_item_name'     => __( 'New Industry Name', 'textdomain' ),
		'menu_name'         => __( 'Industries', 'textdomain' ),
	);

	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'industry' ),
	);

	register_taxonomy( 'industry', 'product', $args );

	// Add new taxonomy, make it hierarchical (like categories)
	$labels = array(
		'name'              => _x( 'Agencies', 'taxonomy general name', 'textdomain' ),
		'singular_name'     => _x( 'Agency', 'taxonomy singular name', 'textdomain' ),
		'search_items'      => __( 'Search Agency', 'textdomain' ),
		'all_items'         => __( 'All Agency', 'textdomain' ),
		'parent_item'       => __( 'Parent Agency', 'textdomain' ),
		'parent_item_colon' => __( 'Parent Agency:', 'textdomain' ),
		'edit_item'         => __( 'Edit Agency', 'textdomain' ),
		'update_item'       => __( 'Update Agency', 'textdomain' ),
		'add_new_item'      => __( 'Add New Agency', 'textdomain' ),
		'new_item_name'     => __( 'New Agency Name', 'textdomain' ),
		'menu_name'         => __( 'Agencies', 'textdomain' ),
	);

	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'agency' ),
	);

	register_taxonomy( 'agency', 'product', $args );
	$labels = array(
		'name'              => _x( 'States', 'taxonomy general name', 'textdomain' ),
		'singular_name'     => _x( 'State', 'taxonomy singular name', 'textdomain' ),
		'search_items'      => __( 'Search State', 'textdomain' ),
		'all_items'         => __( 'All State', 'textdomain' ),
		'parent_item'       => __( 'Parent State', 'textdomain' ),
		'parent_item_colon' => __( 'Parent State:', 'textdomain' ),
		'edit_item'         => __( 'Edit State', 'textdomain' ),
		'update_item'       => __( 'Update State', 'textdomain' ),
		'add_new_item'      => __( 'Add New State', 'textdomain' ),
		'new_item_name'     => __( 'New State Name', 'textdomain' ),
		'menu_name'         => __( 'States', 'textdomain' ),
	);

	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'statendustry' ),
	);

	register_taxonomy( 'state', 'product', $args );
}



if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_VERSION', '2.2.0' );

if ( ! isset( $content_width ) ) {
	$content_width = 800; // Pixels.
}

if ( ! function_exists( 'hello_elementor_setup' ) ) {
	/**
	 * Set up theme support.
	 *
	 * @return void
	 */
	function hello_elementor_setup() {
		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_load_textdomain', [ true ], '2.0', 'hello_elementor_load_textdomain' );
		if ( apply_filters( 'hello_elementor_load_textdomain', $hook_result ) ) {
			load_theme_textdomain( 'hello-elementor', get_template_directory() . '/languages' );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_menus', [ true ], '2.0', 'hello_elementor_register_menus' );
		if ( apply_filters( 'hello_elementor_register_menus', $hook_result ) ) {
			register_nav_menus( array( 'menu-1' => __( 'Primary', 'hello-elementor' ) ) );
		}

		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_theme_support', [ true ], '2.0', 'hello_elementor_add_theme_support' );
		if ( apply_filters( 'hello_elementor_add_theme_support', $hook_result ) ) {
			add_theme_support( 'post-thumbnails' );
			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'title-tag' );
			add_theme_support(
				'html5',
				array(
					'search-form',
					'comment-form',
					'comment-list',
					'gallery',
					'caption',
				)
			);
			add_theme_support(
				'custom-logo',
				array(
					'height'      => 100,
					'width'       => 350,
					'flex-height' => true,
					'flex-width'  => true,
				)
			);

			/*
			 * Editor Style.
			 */
			add_editor_style( 'editor-style.css' );

			/*
			 * WooCommerce.
			 */
			$hook_result = apply_filters_deprecated( 'elementor_hello_theme_add_woocommerce_support', [ true ], '2.0', 'hello_elementor_add_woocommerce_support' );
			if ( apply_filters( 'hello_elementor_add_woocommerce_support', $hook_result ) ) {
				// WooCommerce in general.
				add_theme_support( 'woocommerce' );
				// Enabling WooCommerce product gallery features (are off by default since WC 3.0.0).
				// zoom.
				add_theme_support( 'wc-product-gallery-zoom' );
				// lightbox.
				add_theme_support( 'wc-product-gallery-lightbox' );
				// swipe.
				add_theme_support( 'wc-product-gallery-slider' );
			}
		}
	}
}
add_action( 'after_setup_theme', 'hello_elementor_setup' );

if ( ! function_exists( 'hello_elementor_scripts_styles' ) ) {
	/**
	 * Theme Scripts & Styles.
	 *
	 * @return void
	 */
	function hello_elementor_scripts_styles() {
		$enqueue_basic_style = apply_filters_deprecated( 'elementor_hello_theme_enqueue_style', [ true ], '2.0', 'hello_elementor_enqueue_style' );
		$min_suffix          = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		if ( apply_filters( 'hello_elementor_enqueue_style', $enqueue_basic_style ) ) {
			wp_enqueue_style(
				'hello-elementor',
				get_template_directory_uri() . '/style' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}

		if ( apply_filters( 'hello_elementor_enqueue_theme_style', true ) ) {
			wp_enqueue_style(
				'hello-elementor-theme-style',
				get_template_directory_uri() . '/theme' . $min_suffix . '.css',
				[],
				HELLO_ELEMENTOR_VERSION
			);
		}
	}
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_scripts_styles' );

if ( ! function_exists( 'hello_elementor_register_elementor_locations' ) ) {
	/**
	 * Register Elementor Locations.
	 *
	 * @param ElementorPro\Modules\ThemeBuilder\Classes\Locations_Manager $elementor_theme_manager theme manager.
	 *
	 * @return void
	 */
	function hello_elementor_register_elementor_locations( $elementor_theme_manager ) {
		$hook_result = apply_filters_deprecated( 'elementor_hello_theme_register_elementor_locations', [ true ], '2.0', 'hello_elementor_register_elementor_locations' );
		if ( apply_filters( 'hello_elementor_register_elementor_locations', $hook_result ) ) {
			$elementor_theme_manager->register_all_core_location();
		}
	}
}
add_action( 'elementor/theme/register_locations', 'hello_elementor_register_elementor_locations' );

if ( ! function_exists( 'hello_elementor_content_width' ) ) {
	/**
	 * Set default content width.
	 *
	 * @return void
	 */
	function hello_elementor_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'hello_elementor_content_width', 800 );
	}
}
add_action( 'after_setup_theme', 'hello_elementor_content_width', 0 );

if ( is_admin() ) {
	require get_template_directory() . '/includes/admin-functions.php';
}

if ( ! function_exists( 'hello_elementor_check_hide_title' ) ) {
	/**
	 * Check hide title.
	 *
	 * @param bool $val default value.
	 *
	 * @return bool
	 */
	function hello_elementor_check_hide_title( $val ) {
		if ( defined( 'ELEMENTOR_VERSION' ) ) {
			$current_doc = \Elementor\Plugin::instance()->documents->get( get_the_ID() );
			if ( $current_doc && 'yes' === $current_doc->get_settings( 'hide_title' ) ) {
				$val = false;
			}
		}
		return $val;
	}
}
add_filter( 'hello_elementor_page_title', 'hello_elementor_check_hide_title' );

/**
 * Wrapper function to deal with backwards compatibility.
 */
if ( ! function_exists( 'hello_elementor_body_open' ) ) {
	function hello_elementor_body_open() {
		if ( function_exists( 'wp_body_open' ) ) {
			wp_body_open();
		} else {
			do_action( 'wp_body_open' );
		}
	}
}
function woo_add_cart_fee() {

global $woocommerce;

if(isset($_GET['rats']) && $_GET['rats']=='1'){
$woocommerce->cart->add_fee( __('Annual Software Subscription (Per User)', 'woocommerce'), 0, TRUE);
WC()->session->set('removed_fee_session', 1);
//$_SESSION['removed_fee'] = 1;
}
else if(WC()->session->get('removed_fee_session') )
{
    $woocommerce->cart->add_fee( __('Annual Software Subscription (Per User)', 'woocommerce'), 0, TRUE);
}
else{
WC()->session->set('removed_fee_session', 0);
$tech_per_item = 89;

/*$num_of_items = $woocommerce->cart->cart_contents_count;
$tech_total = $num_of_items * $tech_per_item;*/

$tech_total = $tech_per_item;
$woocommerce->cart->add_fee( __('Annual Software Subscription (Per User)', 'woocommerce'), $tech_total, TRUE);
}
    
}
add_action( 'woocommerce_cart_calculate_fees', 'woo_add_cart_fee' );

add_action('woocommerce_add_to_cart', 'custome_add_to_cart');
function custome_add_to_cart() {
    WC()->session->set('removed_fee_session', 0);
}

function rats_checkout_url($checkout_url){
	if(isset($_GET['rats']) && $_GET['rats']=='1'){ 
		$checkout_url = add_query_arg('rats',1,$checkout_url);
	}
	return $checkout_url;
}
add_filter('woocommerce_get_checkout_url','rats_checkout_url');

add_filter( 'woocommerce_get_price_html', 'custom_price_message' );
function custom_price_message( $price ) {
        if(is_single()){
	$vat = ' (for one license on one pc)';
	return $price . $vat;
        }else{
        return $price;
        }
}

// disable for posts
add_filter('use_block_editor_for_post', '__return_false', 10);
add_action( 'woocommerce_before_add_to_cart_form', 'dev_designs_show_sku', 5 );
function dev_designs_show_sku(){
    global $product;
	echo '<h4>' . $product->get_sku() .'</h4>';
}

add_action('woocommerce_email_after_order_table', 'wooccm_order_receipt_checkout_details', 10, 3);

function wooccm_order_receipt_checkout_details($order, $sent_to_admin, $plain_text = '') {

  if (class_exists('WOOCCM')) {

    $billing_defaults = WOOCCM()->billing->get_defaults();
    $shipping_defaults = WOOCCM()->shipping->get_defaults();
    $additional_defaults = WOOCCM()->additional->get_defaults();

    $billing = WOOCCM()->billing->get_fields();
    $shipping = WOOCCM()->shipping->get_fields();
    $additional = WOOCCM()->additional->get_fields();

    if (!empty($additional)) {

      foreach ($additional as $btn) {

        if (!in_array($btn['name'], $additional_defaults)) {

          if (( get_post_meta($order->get_id(), sprintf('_%s', $btn['key']), true) !== '' ) &&
                  !empty($btn['label']) &&
                  $btn['type'] !== 'heading' &&
                  $btn['type'] !== 'multiselect' &&
                  $btn['type'] !== 'file' &&
                  $btn['type'] !== 'multicheckbox'
          ) {
            echo ' 
            <p>
	          <strong>'. $btn['label'] .':</strong> '. nl2br(get_post_meta($order->get_id(), sprintf('_%s', $btn['key']), true)).'
</p>';
          } elseif (
                  !empty($btn['label']) &&
                  $btn['type'] == 'heading' &&
                  $btn['type'] !== 'multiselect' &&
                  $btn['type'] !== 'file' &&
                  $btn['type'] !== 'multicheckbox'
          ) {
            echo '
             <h2>' . $btn['label'] . '</h2>';
          } elseif (
                  ( get_post_meta($order->get_id(), sprintf('_%s', $btn['key']), true) !== '' ) &&
                  !empty($btn['label']) &&
                  $btn['type'] !== 'heading' &&
                  $btn['type'] !== 'file' &&
                  (
                  $btn['type'] == 'multiselect' || $btn['type'] == 'multicheckbox'
                  )
          ) {
            $value = get_post_meta($order->get_id(), sprintf('_%s', $btn['key']), true);
            $strings = maybe_unserialize($value);
            echo '
<p>
	<strong>'. $btn['label'].':</strong> ';
            if (!empty($strings)) {
              if (is_array($strings)) {
                $iww = 0;
                $len = count($strings);
                foreach ($strings as $key) {
                  if ($iww == $len - 1) {
                    echo $key;
                  } else {
                    echo $key . ', ';
                  }
                  $iww++;
                }
              } else {
                echo $strings;
              }
            } else {
              echo '-';
            }
            echo '
</p>';
          }
        }
      }
    }
  }
}